/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import intrinsic.mx.controls.dataGridClasses.DataGridColumn;
import intrinsic.mx.controls.listClasses.ListBase;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.internal.flex.*;
import org.eclipse.swt.events.*;

public class TableColumn extends Item {
	DataGridColumn column;
	Table parent;

public TableColumn (Table parent, int style) {
	super (parent, checkStyle (style));
	this.parent = parent;
	parent.createItem (this, parent.getColumnCount ());
}

public TableColumn (Table parent, int style, int index) {
	super (parent, checkStyle (style));
	this.parent = parent;
	parent.createItem (this, index);
}

public void addControlListener (ControlListener listener) {
}

public void addSelectionListener (SelectionListener listener) {
}

static int checkStyle (int style) {
	return checkBits (style, SWT.LEFT, SWT.CENTER, SWT.RIGHT, 0, 0, 0);
}

protected void checkSubclass () {
	if (!isValidSubclass ()) error (SWT.ERROR_INVALID_SUBCLASS);
}

void createHandle () {
	column = new DataGridColumn();
	if (column == null) error(SWT.ERROR_NO_HANDLES);
	column.sortable = false;
	column.itemRenderer = new TableItemRendererClassFactory(parent, this, false);
	column.headerRenderer = new TableItemRendererClassFactory(parent, this, true);
}

void destroyWidget() {
	parent.destroyItem (this);
	releaseHandle ();
}

public int getAlignment () {
	checkWidget ();
	return 0;
}

public Table getParent () {
	checkWidget ();
	return parent;
}

public boolean getMoveable () {
	checkWidget ();
	return column.draggable;
}

public boolean getResizable () {
	checkWidget ();
	return column.resizable;
}

public String getToolTipText () {
	return "";
}

public int getWidth () {
	checkWidget();
	return (int)column.width;
}

public void pack () {
}

public void removeControlListener (ControlListener listener) {
}

public void removeSelectionListener (SelectionListener listener) {
}

void releaseHandle () {
	super.releaseHandle ();
	column = null;
	parent = null;
}

public void setAlignment (int alignment) {
}

public void setImage (Image image) {
	super.setImage(image);
	((ListBase)parent.object).invalidateList();
}

public void setMoveable (boolean moveable) {
	checkWidget();
	column.draggable = moveable;
}

public void setResizable (boolean resizable) {
	checkWidget();
	column.resizable = resizable;
}

public void setText (String string) {
	checkWidget ();
	if (string == null) error (SWT.ERROR_NULL_ARGUMENT);
	if (string.equals (text)) return;
	text = string;
	column.headerText = text;
}

public void setToolTipText (String string) {
}

public void setWidth (int width) {
	checkWidget ();
	if (width < 0) return;
	column.width = width;
}

}
